# coding: utf-8
from collections import namedtuple

CursorDescription = namedtuple('CursorDescription', ('name', 'type'))


class FakeCursor(object):

    def __init__(self, column_names=None, rows=None):
        self.rows = rows
        self.column_names = column_names

    @property
    def description(self):
        return [CursorDescription(c, None) for c in self.column_names]

    def fetchone(self):
        if self.rows:
            result = self.rows[0]
            self.rows = self.rows[1:]
            return result
        return None

    def execute(self, query, args):
        pass

    def fetchall(self):
        return self

    fetchmany = fetchall

    def __iter__(self):
        return iter(self.rows)
