# coding: utf-8

from enum import Enum, unique
from psycopg2.extensions import ISQLQuote, adapt


@unique
class DBEnum(Enum):
    def name_in_db(self):
        raise NotImplementedError(
            'Add enum name in DB!'
        )

    def __conform__(self, proto):
        if proto is ISQLQuote:
            return self

    def __eq__(self, other):
        return super(DBEnum, self) == other or self.value == other

    def getquoted(self):
        return b'%s::%s' % (adapt(self.value).getquoted(), self.name_in_db().encode('utf-8'))

# Example:
# class ThreadsMergeRule(DBEnum):
#     hash = 'hash'
#     references = 'references'
#     force_new_thread = 'force-new-thread'
#     undefined = 'undefined'
#
#     def name_in_db(self):
#         return 'mail.thread_merge_rules'
