import yaml


def update_config(old_path, new_path, update_dict, allow_new_keys=False):
    data = load_config(old_path)
    for k, v in update_dict.items():
        elem = data
        keys = k.split(".")
        for key in keys[:-1]:
            if isinstance(elem, list):
                try:
                    # try to treat key as index
                    elem = elem[int(key)]
                except (ValueError, IndexError):
                    # try to find by _name field
                    found = False
                    for e in elem:
                        if isinstance(e, dict) and e.get("_name", None) == key:
                            elem = e
                            found = True
                            break
                    if not found:
                        raise RuntimeError("Key not found: {}".format(key))

            elif isinstance(elem, dict):
                if key not in elem and allow_new_keys:
                    elem[key] = {}
                elem = elem.get(key)
                if elem is None:
                    raise RuntimeError("Unknown dict keys: {}".format(key))
            else:
                raise RuntimeError("Unknown node type: {}".format(type(elem)))
        elem[keys[-1]] = v
    write_config(data, new_path)


def load_config(path):
    with open(path, "r") as stream:
        return yaml.safe_load(stream)


def write_config(data, path):
    with open(path, "w") as outfile:
        yaml.dump(data, outfile, default_flow_style=False)
