from xml.etree import ElementTree as ET


def str_attributes(attrib):
    return dict(
        (k, str(v)) for (k, v) in attrib.items()
    )


class BlackBoxDoc(object):
    def __init__(self):
        self.doc = ET.Element('doc')

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        pass

    def add(self, tag, **attrib):
        new_el = ET.Element(tag, attrib=str_attributes(attrib))
        self.doc.append(new_el)
        return new_el

    def __str__(self):
        return ET.tostring(self.doc)
