CREATE SCHEMA IF NOT EXISTS fbb;

DROP FUNCTION IF EXISTS public.emails(fbb.users);
DROP FUNCTION IF EXISTS fbb.default_domains();
DROP TABLE IF EXISTS fbb.users;


CREATE OR REPLACE FUNCTION fbb.default_domains()
    RETURNS TABLE(is_corp boolean, domain text) AS $$
        SELECT is_corp, domain
          FROM (VALUES
                (false, 'yandex.ru'),
                (false, 'mail.yandex.ru'),
                (true, 'yandex-team.ru'),
                (true, 'mail.yandex-team.ru')
        ) AS v(is_corp, domain);
$$ LANGUAGE sql IMMUTABLE;


CREATE TABLE fbb.sessionid (
    name text NOT NULL,
    xml text NOT NULL,
    CONSTRAINT pk_sessionid PRIMARY KEY (name)
);


CREATE TABLE fbb.users (
    uid     bigint NOT NULL,
    suid    bigint,
    login   text,
    db      text,
    is_corp boolean DEFAULT false,
    is_maillist boolean DEFAULT false,
    orgid   integer,
    userinfo_response  text DEFAULT NULL,
    sids    integer[] NOT NULL DEFAULT array[]::integer[],
    CONSTRAINT pk_users PRIMARY KEY (uid),
    CONSTRAINT uk_users_suid UNIQUE (suid),
    CONSTRAINT uk_users_login UNIQUE (login)
);


CREATE OR REPLACE FUNCTION public.emails(fbb.users)
    RETURNS text[] AS $$
        SELECT ARRAY(
            SELECT $1.login || '@' || dd.domain
              FROM fbb.default_domains() dd
             WHERE $1.is_corp = dd.is_corp
        );
$$ LANGUAGE SQL STABLE;
