from json import dumps

from werkzeug.wrappers import Response

from fbb.user_type import UserType


class IntranetHandler(object):
    """https://wiki.yandex-team.ru/passport/api/bundle/registration/intranet/#url"""
    def __init__(self, db):
        self.db = db

    def user_exists(self, login):
        return self.db.check_user_exists(login)

    def get_user_type(self, is_maillist):
        POSITIVE_VALUES = ['true', 't', 'yes', 'y', 'on', '1']
        NEGATIVE_VALUES = ['false', 'f', 'no', 'n', 'off', '0']

        if is_maillist in POSITIVE_VALUES:
            return UserType.MAILLIST
        if is_maillist in NEGATIVE_VALUES:
            return UserType.REGULAR
        return None

    def error(self, *errors, **kwargs):
        if not errors:
            errors = ['backend.blackbox_permanent_error']
        return Response(dumps(dict(
            status='error',
            errors=errors,
            **kwargs
        )))

    def ok(self, uid):
        return Response(dumps({
            'status': 'ok',
            'uid': uid,
        }))

    def __call__(self, request):
        db = 'pg'

        login = request.get_arg('login').partition('@')[0]
        if not login or self.user_exists(login):
            return self.error('login.notavailable', login=login)

        is_maillist = request.get_arg('is_maillist')
        if is_maillist is None:
            is_maillist = 'false'
        user_type = self.get_user_type(is_maillist.lower())
        if user_type is None:
            return self.error('is_maillist.wrong', is_maillist=is_maillist)

        args = {
            'login': login,
            'db': db,
            'user_type': user_type,
            'userinfo_response': request.post_arg('userinfo_response') or request.get_arg('userinfo_response'),
            'uid': request.get_arg('uid'),
            'orgid': request.get_arg('orgid', 0)
        }

        uid, _ = self.db.create_user(**args)
        return self.ok(uid)
