from six import text_type
from werkzeug.wrappers import Response

from fbb.bb_response import not_implemented, mailhost_error_response, unknown_op_handler, ok_response
from fbb.errors import BlackBoxDBErrror


class MailhostHandler(object):
    """https://wiki.yandex-team.ru/passport/api/mailhost/"""
    OPS = [
        'create',
        'delete',
        'setprio',
        'find',
        'assign',
    ]

    def __init__(self, db):
        self.db = db

    def assign(self, request):
        assign_args = {
            'db_id': text_type,
            'old_db_id': text_type,
            'suid': int,
        }
        OPTIONAL_ARGS = ['old_db_id']
        for arg_name, arg_type in assign_args.items():
            arg_value = request.get_arg(arg_name)
            if arg_value is None:
                if arg_name not in OPTIONAL_ARGS:
                    return mailhost_error_response('missing argument %s' % arg_name)
                assign_args['old_db_id'] = arg_value
            else:
                try:
                    assign_args[arg_name] = arg_type(arg_value)
                except ValueError as exc:
                    return mailhost_error_response('malformed argument %s: %r' % (arg_name, exc.message))
        try:
            self.db.set_db(
                suid=assign_args['suid'],
                db=assign_args['db_id'],
                old_db=assign_args['old_db_id'],
            )
        except BlackBoxDBErrror as exc:
            return mailhost_error_response(exc.message)
        return ok_response()

    def __call__(self, request):
        op = request.get_arg('op')
        handler = unknown_op_handler
        try:
            handler = getattr(self, op)
        except AttributeError:
            return not_implemented(
                request,
                'operation %r not implemented' % op
            )
        response = handler(request)
        return Response(str(response), mimetype='text/xml')
