import psycopg2 as pg


class SessionidDBFromPG(object):
    def __init__(self, dsn):
        self.dsn = dsn

    def save_sessionid(self, name, xml):
        with pg.connect(dsn=self.dsn) as conn:
            cur = conn.cursor()
            cur.execute(
                '''INSERT INTO fbb.sessionid (name, xml)
                   VALUES (%(name)s, %(xml)s)
                   ON CONFLICT DO NOTHING''',
                dict(name=name, xml=xml),
            )
            return name

    def get_sessionid(self, name):
        with pg.connect(dsn=self.dsn) as conn:
            cur = conn.cursor()
            cur.execute(
                '''SELECT xml
                     FROM fbb.sessionid
                    WHERE name = %(name)s
                ''',
                dict(name=name)
            )
            res = cur.fetchone()
            return res[0] if res is not None else None
