from json import dumps

from werkzeug.wrappers import Response


class SessionidHandler(object):
    def __init__(self, db):
        self.db = db

    def error(self, *errors, **kwargs):
        if not errors:
            errors = ['backend.blackbox_permanent_error']
        return Response(dumps(dict(
            status='error',
            errors=errors,
            **kwargs
        )))

    def ok(self, uid):
        return Response(dumps({
            'status': 'ok',
        }))

    def __call__(self, request):
        args = {
            'name': request.get_arg('name'),
            'xml': request.post_arg('xml') or request.get_arg('xml'),
        }

        self.db.save_sessionid(**args)
        return Response(dumps({
            'status': 'ok',
        }))
