class UserType(object):
    REGULAR = 'regular'
    MAILLIST = 'maillist'


def possible_uids(user_type):
    if user_type == UserType.REGULAR:
        return range(1000, 10 * 1000)
    if user_type == UserType.MAILLIST:
        return range(10 * 1000, 20 * 1000)
    return []


def possible_suids(user_type):
    for x in possible_uids(user_type):
        yield x * 1000 + 999
