import argparse
import os
import yaml


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-c', '--config', help="Path to config",
                        default=os.environ.get('TEMPLATE_IDENTIFIER_CONFIG'))
    parser.add_argument('--autoreload', action='store_true', help="Tornado autoreload mode")

    args = parser.parse_args()

    if args.autoreload:
        # Store config path to env variable, because tornado autoreload drops
        #   all command-line arguments so env variable is the only way
        #   to preserve config path after autoreloading
        os.environ['TEMPLATE_IDENTIFIER_CONFIG'] = args.config

    return args


def load_settings():
    args = parse_args()

    with open(args.config, 'r') as f:
        conf = yaml.load(f.read())
        conf.update(vars(args))
    return conf
