# coding: utf-8

import simplejson as json
from datetime import datetime
from functools import wraps

from werkzeug.wrappers import Response


class DateTimeEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, datetime):
            return obj.isoformat()
        return json.JSONEncoder.default(self, obj)


def jdumps(obj):
    return json.dumps(obj, cls=DateTimeEncoder, ensure_ascii=True)


def make_json_response(obj):
    return Response(jdumps(obj), mimetype='application/json')


def json_response(func):
    """
    Wrap function returning JSON-able object with this decorator
    to get Werkzeug-friendly request handler.
    """
    @wraps(func)
    def deco(*args, **kwargs):
        obj = func(*args, **kwargs)
        return make_json_response(obj)
    return deco
