import signal
import sys
import subprocess
import socket


def _send_ok(clientsocket):
    response_headers = {
        'Content-Type': 'text/html; encoding=utf8',
        'Connection': 'close',
    }
    response_headers_raw = ''.join('%s: %s\r\n' %
                                   (k, v) for k, v in response_headers.items())
    response_proto = 'HTTP/1.1'
    response_status = '200'
    response_status_text = 'OK'

    r = '%s %s %s\r\n' % (response_proto, response_status,
                          response_status_text)
    clientsocket.send(r)
    clientsocket.send(response_headers_raw)
    clientsocket.send('\r\n')
    clientsocket.close()


def _stop_hook():
    print("Received a shutdown hook, starting blocking nginx")
    subprocess.call(["ln", "-svf", "/etc/nginx/includes/lock_ping",
                     "/etc/nginx/includes/lock_ping.safe"])
    print("Made a symbolic link")
    subprocess.call(["nginx", "-s", "reload"])
    subprocess.call(["rm", "-v", "/etc/nginx/includes/lock_ping.safe"])
    print("Restarted nginx...")


def sigterm_handler(_signo, _stack_frame):
    print("Received a sigterm signal, stopping the process")
    sys.exit(0)


def _main():
    PORT = 23456
    signal.signal(signal.SIGTERM, sigterm_handler)

    try:
        print("Creating the server socket")
        serversocket = socket.socket(socket.AF_INET6, socket.SOCK_STREAM)
        serversocket.bind(("localhost", PORT))
        serversocket.listen(5)
        print("Starting main waiting cycle...")
        while True:
            (clientsocket, address) = serversocket.accept()
            _stop_hook()
            _send_ok(clientsocket)
    finally:
        print("Main cycle is interrupted")


if __name__ == "__main__":
    _main()
