```
                   _________                    _____            ______
_________________________  /_______      ______ __  /_______________  /_______
__  ___/  _ \_  __ \  __  /__  ___/_______  __ `/  __/  __ \  __ \_  /__  ___/
_(__  )/  __/  / / / /_/ / _  /   _/_____/ /_/ // /_ / /_/ / /_/ /  / _(__  )
/____/ \___//_/ /_/\__,_/  /_/           \__, / \__/ \____/\____//_/  /____/
                                           /_/
```

Вспомогательные инструменты для развертывания микросервисов
в Qloud

## Компоненты

### sendr_qlog

Форматер логирования для записи логов в формате Qloud с
поддержкой контекстов логирования

### sendr_qstats

Сбор метрик выполнения и публикация в ручке в формате unistat

### sendr_settings

Конфигурация из набора файлов с учетом среды, задаваемой в yenv

### sendr_aiohttp

Утилиты для использования с сервером aiohttp
[Подробнее](src/sendr_aiohttp/README.md)

### sendr_cmncommands

Полезные команды общего назначения

### sendr_tvm

Клиентские и серверные утилиты для использования TVM

### sendr_taskqueue

Заготовки для асинхронных воркеров в виде отдельного сервиса со сбором статистики.

Пример в `src/sendr_taskqueue/examples`


## Разработка
Поскольку остается ряд проектов, которые еще не заехали в аркадию, существуют некоторые обвязки, которые обеспечивают совместимость сред выполнения.

### Подготовка virtualenv (вне аркадии)
```
virtualenv -p python3.7 env
source env/bin/activate
pipenv install --dev
```

### Запуск тестов

В аркадии:
```
make test-ya
```

Вне аркадии
```
make test
```

### mypy
Проверяет все, но игнорирует ошибки из пакетов, которые не поддерживают аннотации.
```
make cc
```

## Что делать, если я вдруг хочу разрабатывать на `Go`?
Библиотека с похожими идеями: [billing/library/go/billingo](https://a.yandex-team.ru/arc/trunk/arcadia/billing/library/go/billingo)
