# -*- encoding: utf-8 -*-
import sys
from setuptools import setup, find_packages

from setuptools.command.test import test as TestCommand

NAME = 'sendr-qtools'
DESCRIPTION = 'Collection of usefull tools for Qloud for Swat services'
URL = 'https://github.yandex-team.ru/sendr/sendr-qtools'
EMAIL = 'swatsup@yandex-team.ru'
AUTHOR = 'Andrey Mitrofanov'

REQUIRED = [
    'IPython',
    'aiopg',
    'aiofiles',
    'apispec==0.39.0',
    'click',
    'dataclasses;python_version<"3.7"',
    'Deprecated',
    'psycopg2-binary',
    'setuptools',
    'six',
    'sqlalchemy',
    'ujson==1.35',
    'webargs==5.5.2',
    'yenv',
]

TESTS_REQUIRED = ['pytest', 'pyhamcrest', 'pytest-mock']
AIOHTTP_TESTS_REQUIRED = TESTS_REQUIRED + ['aiohttp', 'pytest-aiohttp']
MYPY_TESTS_REQUIRED = AIOHTTP_TESTS_REQUIRED + ['mypy', 'sqlalchemy-stubs']


class PyTest(TestCommand):
    user_options = []

    def run(self):
        import subprocess
        errno = subprocess.call([sys.executable, '-m', 'pytest'])
        raise SystemExit(errno)


setup(
    name=NAME,
    version='0.1.6',
    author=AUTHOR,
    author_email=EMAIL,
    description=DESCRIPTION,
    url=URL,
    package_dir={'': 'src'},
    packages=find_packages('src', exclude=('tests',)),
    package_data={
        'sendr_aiopg': ['py.typed'],
        'sendr_interactions': ['py.typed'],
        'sendr_logbroker': ['py.typed']
    },
    install_requires=REQUIRED,
    zip_safe=False,
    extras_require={
        'test': TESTS_REQUIRED,
        'test_aiohttp': AIOHTTP_TESTS_REQUIRED,
        'test_all': MYPY_TESTS_REQUIRED,
    },
    cmdclass=dict(test=PyTest),
    entry_points={
        'pytest11': ['sendr_pytest = sendr_pytest'],
    },
)
