import signal

from aiohttp import web


def get_ping_handler():
    is_ready = True

    def handle_sigusr1(signum, frame):
        nonlocal is_ready
        is_ready = False

    def handle_sigusr2(signum, frame):
        nonlocal is_ready
        is_ready = True

    signal.signal(signal.SIGUSR1, handle_sigusr1)
    signal.signal(signal.SIGUSR2, handle_sigusr2)

    def _handler(request: web.Request) -> web.Response:
        response_args = dict(text='pong')
        if not is_ready:
            response_args.update({'text': 'server cannot accept requests', 'status': '418'})
        return web.Response(**response_args)  # type: ignore

    return _handler
