from typing import Generic, Optional, TypeVar

from aiopg.sa.engine import Engine

from sendr_aiopg.storage import StorageBase
from sendr_core.context import BaseCoreContext

StorageType = TypeVar('StorageType', bound=StorageBase)


class BaseActionDBContext(Generic[StorageType], BaseCoreContext):
    storage: Optional[StorageType]
    db_engine: Engine
