from typing import Any, Callable, Iterable, Mapping, Optional, Type, TypeVar, Union

from .engine.lazy import LazyEngine, PresetLazyEngine
from .engine.multiple import MultipleEngine, RetryableEngine
from .engine.single import CustomEngine

Entity = TypeVar('Entity')
EntityType = Callable[..., Entity]  # mypy doesn't allow Type[Entity]: error: Unsupported type Type[Entity?]
OptEntityType = Optional[EntityType]

StrList = Iterable[str]
OptStrList = Optional[StrList]

OptException = Optional[Union[Exception, Type[Exception]]]

ValuesList = Iterable[Any]
OptValuesList = Optional[ValuesList]

ValuesMapping = Mapping[str, Any]
OptValuesMapping = Optional[ValuesMapping]

EngineWithUsing = Union[CustomEngine, LazyEngine, RetryableEngine, MultipleEngine]
EngineUnion = Union[EngineWithUsing, PresetLazyEngine]
