from dataclasses import dataclass
from enum import Enum, unique
from typing import Optional


@unique
class AuthenticationMethod(Enum):
    OAUTH = 'oauth'
    SESSION = 'session'


@dataclass
class User:
    uid: int
    tvm_ticket: Optional[str] = None
    login_id: Optional[str] = None
    auth_method: Optional[AuthenticationMethod] = None
    is_yandexoid: bool = False
