

class SecurityException(Exception):
    def __init__(self, code: int, message: str):
        super().__init__()
        self.code = code
        self.message = message

    @property
    def data(self):
        return {
            'message': self.message,
        }


class AuthenticationException(SecurityException):
    def __init__(self, message: str = 'ACCESS_DENIED'):
        super().__init__(code=401, message=message)


class InvalidCSRFTokenException(SecurityException):
    def __init__(self, message: str = 'INVALID_CSRF'):
        super().__init__(code=403, message=message)
