import importlib
import pkgutil

import click


class BuiltinCLI(click.MultiCommand):
    """
        Класс собирает встроенные команды
    """

    def __init__(self, use_commands, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._commands = {x.name: x for x in use_commands}

    def list_commands(self, ctx):
        return list(self._commands.keys())

    def get_command(self, ctx, name):
        return self._commands.get(name)


class CLI(BuiltinCLI):
    """
        Класс собирает общие команды и команды, расположенные в каталоге плагинов
    """

    def __init__(self, plugins_package, *args, **kwargs):
        self._plugins_folder = plugins_package.__path__
        self._plugins_import = plugins_package.__name__
        super().__init__(*args, **kwargs)

    def list_commands(self, ctx):
        rv = super().list_commands(ctx)
        for importer, name, ispkg in pkgutil.iter_modules(self._plugins_folder):
            if name == '__init__':
                continue
            rv.append(name)

        rv.sort()
        return rv

    def get_command(self, ctx, name):
        result = super().get_command(ctx, name)
        if result:
            return result

        command_module = importlib.import_module('{}.{}'.format(self._plugins_import, name))
        return command_module.cli
