from contextvars import ContextVar
from typing import Any

from sendr_qlog import LoggerContext


class _MissingType:
    pass


MISSING = _MissingType()


class ContextVarMeta(type):
    """Wraps every field into property accessing ContextVar"""

    def __init__(cls, name, bases, attributes):
        super().__init__(name, bases, attributes)
        cls_annotations = getattr(cls, '__annotations__', {})
        for a_name, a_cls in cls_annotations.items():
            default = getattr(cls, a_name, MISSING)
            kwargs = {}
            if default is not MISSING:
                kwargs = {'default': default}
            var = ContextVar(f'{name}.{a_name}', **kwargs)
            setattr(cls, a_name, cls._context_var_property(var))

    def _context_var_property(cls, var: ContextVar) -> Any:
        def getter(self):
            try:
                return var.get()
            except LookupError:
                raise AttributeError(var.name)

        def setter(self, value):
            var.set(value)

        return property(getter, setter)


class BaseCoreContext(metaclass=ContextVarMeta):
    request_id: str
    logger: LoggerContext
