import asyncio
from typing import Optional
from uuid import uuid4

from sendr_core import BaseAction as AbstractAction
from sendr_core import BaseCoreContext


class CoreContext(BaseCoreContext):
    connection: Optional[str] = None


class BaseAction(AbstractAction):
    context = CoreContext()


class BaseDBAction(BaseAction):
    async def _run(self):
        if self.context.connection is None:
            self.context.connection = uuid4().hex
            print('Connection is None. Initializing:', self.context.connection)
        else:
            print('Connection is present:', self.context.connection)
        return await super()._run()


class FirstAction(BaseDBAction):
    async def handle(self):
        print('First action call.')
        await SecondAction().run()


class SecondAction(BaseDBAction):
    async def handle(self):
        print('Second action call.')


async def main():
    print('BEFORE:', BaseAction.context.connection)
    await FirstAction().run()
    print('AFTER:', BaseAction.context.connection)


if __name__ == '__main__':
    loop = asyncio.get_event_loop()
    loop.run_until_complete(main())
