from typing import Any, ClassVar, List, Optional, Tuple, Type

from sendr_utils import str_to_underscore


def get_error_message(cls: Type) -> str:
    message = str_to_underscore(cls.__name__).lstrip('_').upper().lstrip('_')
    if message.endswith('_ERROR'):
        message = message[:-len('_ERROR')]
    return message


class BaseCoreError(Exception):
    caused_by: ClassVar[Tuple[Type[Exception], ...]] = ()
    core_cause_errors: ClassVar[List[Tuple[Type[Exception], Tuple[Type[Exception], ...]]]] = []

    def __init_subclass__(cls, **kwargs: Any):
        if cls.caused_by:
            BaseCoreError.core_cause_errors.append((cls, cls.caused_by))


class BaseCoreWithMessageError(BaseCoreError):
    """
    New wave of base exceptions

    Example:

    class CoreError(BaseCoreWithMessageError, message='foo'):
       pass

    """

    MESSAGE: ClassVar[Optional[str]] = None

    def __init__(self, message: Optional[str] = None, params: Optional[dict] = None):
        self.message = message or self.MESSAGE
        self.params: dict = params or dict()

    def __init_subclass__(cls, message: Optional[str] = None, **kwargs: Any):
        if message is None:
            cls.MESSAGE = get_error_message(cls)
        else:
            cls.MESSAGE = message
        super().__init_subclass__(**kwargs)


class CoreFailError(BaseCoreError):
    pass
