class BaseStorageException(Exception):
    pass


class FileError(BaseStorageException):
    filename = ''

    def __init__(self, filename=None, *args, **kwargs):
        if filename:
            self.filename = filename
        super().__init__(*args, **kwargs)


class FileExists(FileError):
    pass


class FileNotFound(FileError):
    pass


class IsADirectory(FileError):
    pass


class NotADirectory(FileError):
    pass


class StorageClientException(BaseStorageException):
    pass


class AccessDenied(StorageClientException):
    pass
