from sendr_interactions.exceptions import InteractionResponseError


class BaseBlackboxError(InteractionResponseError):
    def __init__(self, *, status_code=0, method=None, message=None, params=None):
        super().__init__(status_code=status_code, service='blackbox', method=method, message=message)
        self.params = params


class BlackBoxInvalidSessionError(BaseBlackboxError):
    default_message = 'Invalid session data'


class UnknownBlackboxError(BaseBlackboxError):
    pass


class UserNotFoundBlackboxError(BaseBlackboxError):
    pass
