from marshmallow import fields

from sendr_interactions.clients.blackbox.entities import Email, UIDData, UserInfo
from sendr_utils.schemas.dataclass import BaseDataClassSchema


class EmailSchema(BaseDataClassSchema[Email]):
    address = fields.String()
    default = fields.Boolean()
    native = fields.Boolean()


class UIDDataSchema(BaseDataClassSchema[UIDData]):
    value = fields.Integer()


class UserInfoSchema(BaseDataClassSchema[UserInfo]):
    uid_data = fields.Nested(UIDDataSchema, load_from='uid')
    attributes = fields.Dict()
    address_list = fields.Nested(EmailSchema, many=True, load_from='address-list')
