from typing import Any, Dict

from aiohttp import ClientResponse

from sendr_interactions.base import AbstractInteractionClient, ResponseFormat, ResponseType
from sendr_interactions.clients.sd.entities import ResolveEndpointsResponse
from sendr_interactions.clients.sd.schemas import ResolveEndpointsResponseSchema


class AbstractSDClient(AbstractInteractionClient[Dict[str, Any]]):
    """
    Docs: https://wiki.yandex-team.ru/yp/discovery/usage/
    """
    SERVICE = 'sd'

    BASE_URL = 'http://sd.yandex.net:8080'

    async def _format_response(self, response: ClientResponse) -> ResponseType:
        if self.RESPONSE_FORMAT == ResponseFormat.JSON:
            return await response.json(
                content_type=None,  # sd doesn't set Content-Type header for json response
            )
        return await super()._format_response(response)

    async def resolve_endpoints(
        self,
        cluster_name: str,
        endpoint_set_id: str,
        client_name: str,
    ) -> ResolveEndpointsResponse:
        url = self.endpoint_url('/resolve_endpoints/json')
        response = await self.post(
            'resolve_endpoints',
            url,
            json={
                'cluster_name': cluster_name,
                'endpoint_set_id': endpoint_set_id,
                'client_name': client_name,
                'ruid': self.request_id,
            },
        )
        return ResolveEndpointsResponseSchema().load(response).data
