from dataclasses import dataclass, field
from enum import Enum, unique
from typing import List


@unique
class EndpointResolveStatus(Enum):
    NOT_EXISTS = 0
    NOT_CHANGED = 1
    OK = 2
    EMPTY = 3


@dataclass
class Endpoint:
    id: str = ''
    protocol: str = ''
    fqdn: str = ''
    ip4_address: str = ''
    ip6_address: str = ''
    port: int = 0
    ready: bool = False


@dataclass
class EndpointSet:
    endpoint_set_id: str = ''
    endpoints: List[Endpoint] = field(default_factory=list)


@dataclass
class ResolveEndpointsResponse:
    timestamp: int = 0
    endpoint_set: EndpointSet = field(default_factory=EndpointSet)
    resolve_status: EndpointResolveStatus = field(default=EndpointResolveStatus.NOT_EXISTS)
    host: str = ''
    ruid: str = ''
