from marshmallow import fields
from marshmallow_enum import EnumField

from sendr_interactions.clients.sd.entities import (
    Endpoint, EndpointResolveStatus, EndpointSet, ResolveEndpointsResponse
)
from sendr_utils.schemas.dataclass import BaseDataClassSchema


class EndpointSchema(BaseDataClassSchema[Endpoint]):
    id = fields.String()
    protocol = fields.String()
    fqdn = fields.String()
    ip4_address = fields.String()
    ip6_address = fields.String()
    port = fields.Integer()
    ready = fields.Boolean()


class EndpointSetSchema(BaseDataClassSchema[EndpointSet]):
    endpoint_set_id = fields.String()
    endpoints = fields.Nested(EndpointSchema, many=True)


class ResolveEndpointsResponseSchema(BaseDataClassSchema[ResolveEndpointsResponse]):
    timestamp = fields.Integer()
    endpoint_set = fields.Nested(EndpointSetSchema)
    resolve_status = EnumField(EndpointResolveStatus, by_value=True)
    host = fields.String()
    ruid = fields.String()
