from sendr_interactions import exceptions as interaction_errors


class BaseSparkError(interaction_errors.BaseInteractionError):
    MESSAGE: str = 'Unknown SPARK error'

    def __init__(self, *, message=None):
        super().__init__(service='spark', method='POST', message=message or self.MESSAGE)


class SparkAuthError(BaseSparkError):
    MESSAGE: str = 'SPARK Auth error'


class SparkSessionEndError(BaseSparkError):
    MESSAGE: str = 'SPARK session end error'


class SparkGetInfoError(BaseSparkError):
    MESSAGE: str = 'SPARK GetInfo error'
