from dataclasses import dataclass
from typing import Optional


@dataclass
class Link:
    relationship: str
    issue: str


@dataclass
class IssueStatus:
    id: str
    key: str


@dataclass
class IssueResolution:
    id: str
    key: str


@dataclass
class Issue:
    id: str
    key: str
    status: IssueStatus
    resolution: Optional[IssueResolution] = None


class TicketStatuses:
    """
    Full list:
        curl -H 'Authorization: OAuth ' 'https://st-api.test.yandex-team.ru/v2/statuses' | jq .
        OR: https://st.yandex-team.ru/admin/statuses
    List of available statuses is global, therefore is the same for every queue.
    """
    OPEN = "open"
    IN_PROGRESS = "inProgress"
    RESOLVED = "resolved"
    CLOSED = "closed"


class TicketTransitions:
    """
    These are ids of common ticket workflow transitions.

    Full list of available transitions:
        curl -H 'Authorization: OAuth ' https://st-api.test.yandex-team.ru/v2/issues/PAYORIGINMODTST-3/transitions
    """
    CLOSE = "close"


class TicketResolutions:
    """
    Full list:
        curl -H 'Authorization: OAuth ' 'https://st-api.test.yandex-team.ru/v2/resolutions' | jq .
        OR: https://st.yandex-team.ru/admin/resolutions
    List of available resolutions is global, therefore is the same for every queue.
    """
    DONT_DO = "dontDo"
    SUCCESSFUL = "successful"
    DECLINED = "declined"
