from marshmallow import fields

from sendr_interactions.clients.startrek.entities import Issue, IssueResolution, IssueStatus
from sendr_utils.schemas.base import BaseSchema
from sendr_utils.schemas.dataclass import BaseDataClassSchema


class IssueStatusSchema(BaseDataClassSchema[IssueStatus]):
    data_class = IssueStatus

    id = fields.String(required=True)
    key = fields.String(required=True)


class IssueResolutionSchema(BaseDataClassSchema[IssueResolution]):
    data_class = IssueResolution

    id = fields.String(required=True)
    key = fields.String(required=True)


class IssueSchema(BaseDataClassSchema[Issue]):
    data_class = Issue

    id = fields.String(required=True)
    key = fields.String(required=True)
    status = fields.Nested(IssueStatusSchema, required=True)
    resolution = fields.Nested(IssueResolutionSchema, missing=None)


class IssueLinkSchema(BaseSchema):
    relationship = fields.String()
    issue = fields.String()


class CreateIssueRequestSchema(BaseSchema):
    queue = fields.String()
    summary = fields.String()
    description = fields.String()
    unique = fields.String()
    parent = fields.String()
    links = fields.Nested(IssueLinkSchema, many=True)
    attachment_ids = fields.List(fields.Integer(), attribute='attachmentIds', dump_to='attachmentIds')
    tags = fields.List(fields.String())
