from dataclasses import dataclass
from typing import Dict, List, Optional


@dataclass
class Data:
    push_id: Optional[str] = None
    content_id: Optional[str] = None
    stat_id: Optional[str] = None
    transit_id: Optional[str] = None
    push_uri: Optional[str] = None
    push_action: Optional[str] = None
    topic_push: Optional[str] = None


@dataclass
class Notification:
    title: Optional[str] = None
    body: Optional[str] = None
    icon: Optional[str] = None
    iconId: Optional[str] = None
    link: Optional[str] = None


@dataclass
class Push:
    notification: Notification


@dataclass
class Hypothesis:
    push: Push
    id: Optional[str] = None


@dataclass
class ThrottlePolicies:
    install_id: Optional[str] = None
    device_id: Optional[str] = None
    content_id: Optional[str] = None


@dataclass
class PushRequest:
    receiver: List[str]
    data: Data
    notification: Notification
    ttl: Optional[str] = None
    schedule: Optional[str] = None
    adjust_time_zone: Optional[str] = None
    send_time_frame: Optional[str] = None
    hypotheses: Optional[List[Hypothesis]] = None
    project: Optional[str] = None
    max_expected_receivers: Optional[str] = None
    android_features: Optional[Dict[str, str]] = None
    ios_features: Optional[Dict[str, str]] = None
    browser_features: Optional[Dict[str, str]] = None
    throttle_policies: Optional[ThrottlePolicies] = None
    actions: Optional[Dict[str, str]] = None
    is_data_only: Optional[bool] = None
    spread_interval: Optional[str] = None


@dataclass
class PushResponse:
    id: str
    receiver: List[str]
    data: Dict[str, str]
    request_time: int


@dataclass
class RegistrationsResponse:
    app_id: Optional[str] = None
    app_version: Optional[str] = None
    hardware_id: Optional[str] = None
    push_token: Optional[str] = None
    push_tokens: Optional[Dict[str, str]] = None
    platform: Optional[str] = None
    device_name: Optional[str] = None
    zone_id: Optional[str] = None
    notify_disabled: Optional[bool] = None
    active: Optional[bool] = None
    updated_at: Optional[int] = None
    install_id: Optional[str] = None
    device_id: Optional[str] = None
