from typing import Dict, Optional, Type

from sendr_interactions.exceptions import InteractionResponseError


class BaseZoraInteractionError(InteractionResponseError):
    pass


class ZoraRemoteHostCertificateError(BaseZoraInteractionError):
    default_message = 'Remote host certificate validation error'


_CODE_TO_EXCEPTION: Dict[int, Type[BaseZoraInteractionError]] = {
    1000: ZoraRemoteHostCertificateError,
}


def get_zora_exception_by_code(code: int) -> Optional[Type[BaseZoraInteractionError]]:
    return _CODE_TO_EXCEPTION.get(code)
