import asyncio
import logging

from aiohttp import TCPConnector

from sendr_interactions.base import AbstractInteractionClient, ResponseFormat
from sendr_qlog import LoggerContext


class BaseInteractionClient(AbstractInteractionClient):
    DEBUG = True
    REQUEST_RETRY_TIMEOUTS = (0.1, 0.2, 0.4)
    TVM_CONFIG = None


class ExampleClient(BaseInteractionClient):
    SERVICE = 'example'
    BASE_URL = 'http://yandex.ru'
    # This client doesn't get a json response which is considered default,
    # but overriding RESPONSE_FORMAT can get us text representation
    # or the response body.
    RESPONSE_FORMAT = ResponseFormat.TEXT

    async def example(self):
        return await self.get(
            'example',
            f'{self.BASE_URL}/ping',
        )


async def main():
    logger = LoggerContext(logging.getLogger(), {})

    # Connector must be created inside loop
    connector = TCPConnector()
    BaseInteractionClient.CONNECTOR = connector

    # Creating client
    client = ExampleClient(logger, '')

    # Sending request
    response = await client.example()
    print(response[:50])

    # Closing client session, must be called before destroying client
    await client.close()

    # Closing connector, must be called on application cleanup
    await connector.close()


if __name__ == '__main__':
    loop = asyncio.get_event_loop()
    loop.run_until_complete(main())
