from kikimr.public.sdk.python.persqueue.auth import OAuthTokenCredentialsProvider, TVMCredentialsProvider

from sendr_logbroker.logbroker import Consumer, Logbroker, LogbrokerException, Producer
from sendr_logbroker.tvm_client import TVMClient


def create_tvm_credential_provider(
    client_name: str,
    host: str,
    port: int,
    destination_client_id: str
) -> TVMCredentialsProvider:
    return TVMCredentialsProvider(
        tvm_client=TVMClient(
            client_name=client_name,
            host=host,
            port=port,
        ),
        destination_client_id=destination_client_id,
    )


__all__ = (
    'Logbroker',
    'Producer',
    'Consumer',
    'LogbrokerException',
    'TVMClient',
    'TVMCredentialsProvider',
    'OAuthTokenCredentialsProvider',
    'create_tvm_credential_provider'
)
