from typing import Dict

from sendr_tvm import qloud_sync_tvm


class TVMClient:
    def __init__(self, client_name: str, host: str, port: int):
        # Logborker не умеет в async tvm.
        self.tvm_ticket_getter = qloud_sync_tvm.QTVM(
            client_name=client_name,
            host=host,
            port=port,
        )

    def get_service_tickets(self, dst_id: int) -> Dict[int, str]:
        ticket = self.tvm_ticket_getter.ticket_getter().get_service_ticket(dst_id)
        return {dst_id: ticket}
