import json

from sendr_qlog.logging.formatters.base import BaseStructureFormatter
from sendr_qlog.logging.formatters.utils import get_level_from_level_name
from sendr_utils import json_value


class DeployMetaFormatter(BaseStructureFormatter):
    def _serialize(self, data):
        message = data['message']
        meta = {}
        if 'level' in data:
            meta['log_level'] = data['level']
            meta['log_level_int'] = get_level_from_level_name(data['level'])

        if 'datetime' in data:
            meta.setdefault('context', {})
            meta['context']['datetime'] = data['datetime']

        if 'stackTrace' in data:
            meta['stack_trace'] = data['stackTrace']
        if 'threadName' in data:
            meta['thread_name'] = data['threadName']

        fields = data.get('@fields')
        if fields:
            meta.setdefault('context', {})

            ctx = fields.get('context', {})
            std = fields.get('std', {})
            meta['context']['std'] = std
            meta['context']['context'] = ctx

            # Поля request_id и user_id мапятся Деплоем в отдельные поля в YT - для скорости поиска
            request_id = ctx.get('request-id', ctx.get('request_id', None))
            if request_id is not None:
                meta['request_id'] = request_id

            user_id = ctx.get('uid', None)
            if user_id:
                meta['user_id'] = user_id

            logger_name = std.get('name', None)
            if logger_name is not None:
                meta['logger_name'] = logger_name
        meta['context'] = json.dumps(json_value(meta['context']))
        return message, meta
