import json

from sendr_qlog.logging.formatters.base import BaseStructureFormatter
from sendr_qlog.logging.formatters.utils import get_level_from_level_name
from sendr_utils import json_value


class DeployUniFormatter(BaseStructureFormatter):
    def _serialize(self, data):
        """
        YANDEXPAY-749
        Формат логов qloud и deploy отличается. Здесь адаптируем формат логов под deploy.
        Учитываем как переименования, так и дополнительные фишки, вроде отдельных полей
        request_id и user_id
        """
        if 'level' in data:
            data['levelStr'] = data['level']
            data['level'] = get_level_from_level_name(data['levelStr'])
        if 'datetime' in data:
            data['@timestamp'] = data['datetime']
            del data['datetime']

        fields = data.get('@fields')
        if fields:
            ctx = fields.get('context', {})
            std = fields.get('std', {})

            # Поля request_id и user_id мапятся Деплоем в отдельные поля в YT - для скорости поиска
            request_id = ctx.get('request-id', ctx.get('request_id', None))
            if request_id is not None:
                data['request_id'] = request_id

            user_id = ctx.get('uid', None)
            if user_id:
                data['user_id'] = user_id

            logger_name = std.get('name', None)
            if logger_name is not None:
                data['loggerName'] = logger_name
        return json.dumps(json_value(data))
