import logging
import sys
from traceback import format_exc

from logbroker.unified_agent.client.python import Client


class UnifiedAgentHandler(logging.Handler):
    def __init__(self,
                 uri,
                 shared_secret_key=None,
                 max_inflight_bytes=None,
                 log_level=None,
                 grpc_reconnect_delay=None,
                 grpc_max_message_size=None,
                 session_meta=None,
                 session=None):
        logging.Handler.__init__(self)
        self._client = None
        if session is not None:
            self._session = session
        else:
            self._client = Client(uri, shared_secret_key, max_inflight_bytes,
                                  log_level, grpc_reconnect_delay, grpc_max_message_size)
            self._session = self._client.create_session(meta=session_meta)

    def close(self):
        self._session.close()
        logging.Handler.close(self)

    def emit(self, record):
        try:
            message, meta = self.format(record)
            self._session.send(message, record.created, meta)
        except Exception as e:
            sys.stderr.write('UnifiedAgentHandler error {}'.format(e))
            sys.stderr.write('UnifiedAgentHandler error {0}\n{1}'.format(e, format_exc()))
