import logging
import os

from sendr_qlog.logging.handlers.unified_agent.handler import UnifiedAgentHandler


class UnifiedAgentYdHandler(logging.Handler):
    def __init__(self,
                 logger_name=None,
                 uri=None,
                 max_inflight_bytes=None,
                 log_level=None,
                 grpc_reconnect_delay=None,
                 grpc_max_message_size=None):

        logger_name_resolved = logger_name
        if (logger_name_resolved is None):
            logger_name_resolved = self.__get_env('DEPLOY_LOGS_DEFAULT_NAME')

        session_meta = dict({
            'deploy_box': self.__get_env('DEPLOY_BOX_ID'),
            'deploy_workload': self.__get_env('DEPLOY_WORKLOAD_ID'),
            'deploy_container_id': self.__get_env('DEPLOY_CONTAINER_ID'),
            'deploy_logger_name': logger_name_resolved,
        })

        self.session_meta = session_meta
        uri_resolved = uri
        if (uri_resolved is None):
            uri_resolved = self.__get_env('DEPLOY_LOGS_ENDPOINT')

        logging.Handler.__init__(self)
        self._handler = UnifiedAgentHandler(uri_resolved, self.__get_env('DEPLOY_LOGS_SECRET'),
                                            max_inflight_bytes, log_level, grpc_reconnect_delay,
                                            grpc_max_message_size, session_meta)

    def close(self):
        self._handler.close()
        logging.Handler.close(self)

    def emit(self, record):
        self._handler.emit(record)

    def __get_env(self, env_name):
        env_value = os.getenv(env_name)
        if (env_value is None):
            raise NameError('{0} env is not specified'.format(env_name))
        return env_value

    def setFormatter(self, formatter):
        self._handler.setFormatter(formatter)
