"""
Библиотека для инструментирования кода для сборщика метрик unistats

Пример:
    from stats import REGISTRY

    REGISTRY.ctype = 'production'
    REQUEST_TIME = Histogram('request_time', labelnames=('route_name', 'method'))
    REQUEST_STATUS_COUNT = Counter('request_status', labelnames=('route_name', 'method', 'status'))

"""

from . import metrics, registry

IntSuff = metrics.IntSuff
AggSuff = metrics.AggSuff
MetricSuffix = metrics.MetricSuffix
SUMM_SUFF = metrics.SUMM_SUFF
HGRAM_SUFF = metrics.HGRAM_SUFF
MAX_SUFF = metrics.MAX_SUFF
ABS_SUM_SUFF = metrics.ABS_SUM_SUFF
Counter = metrics.Counter
Gauge = metrics.Gauge
Summary = metrics.Summary
Histogram = metrics.Histogram

MetricsRegistry = registry.MetricsRegistry
REGISTRY = registry.REGISTRY
