from threading import Lock


class MetricsRegistry(object):
    def __init__(self, ctype=None):
        self._names = {}
        self._lock = Lock()
        self.ctype = ctype

    def register(self, metric):
        with self._lock:
            name = metric.full_name
            if name in self._names:
                raise ValueError('Metric already registered {}'.format(name))
            self._names[name] = metric

    def unregister(self, metric):
        with self._lock:
            name = metric.full_name
            if name in self._names:
                del self._names[name]

    def collect(self):
        ctype_tag = 'ctype={};'.format(self.ctype) if self.ctype else ''
        with self._lock:
            metrics = list(self._names.values())
        for metric in metrics:
            for name, value in metric.get():
                yield (ctype_tag + name, value)


REGISTRY = MetricsRegistry()
