from typing import Optional

from sendr_qstats import Counter, MetricsRegistry

hot_settings_using_failures: Optional[Counter] = None
hot_settings_refresh_failures: Optional[Counter] = None


def safe_inc_using_failures() -> None:
    if hot_settings_using_failures is not None:
        hot_settings_using_failures.inc()


def safe_inc_refresh_failures() -> None:
    if hot_settings_refresh_failures is not None:
        hot_settings_refresh_failures.inc()


def init_hot_settings_using_failures(metrics_registry: MetricsRegistry) -> None:
    global hot_settings_using_failures
    if hot_settings_using_failures is not None:
        return

    hot_settings_using_failures = Counter(
        'hot_settings_using_failures',
        registry=metrics_registry,
    )


def init_hot_settings_refresh_failures(metrics_registry: MetricsRegistry) -> None:
    global hot_settings_refresh_failures
    if hot_settings_refresh_failures is not None:
        return

    hot_settings_refresh_failures = Counter(
        'hot_settings_refresh_failures',
        registry=metrics_registry,
    )
