from typing import Any, Iterable

from aiohttp import web

from sendr_taskqueue.background import BackgroundTask


class StatsTask(BackgroundTask):
    pause_period: int = 5

    def __init__(self, *, stats_updaters: Iterable, **kwargs: Any):
        super().__init__(**kwargs)
        self._stats_updaters = stats_updaters

    async def _run(self) -> None:
        await self.update_stats(self.app)

    async def update_stats(self, app: web.Application) -> None:
        for stats_updater in self._stats_updaters:
            await stats_updater(app)
