from dataclasses import dataclass, field
from datetime import datetime
from enum import Enum, unique
from typing import Any, Dict, Optional

from sendr_aiopg import Entity
from sendr_taskqueue.worker.base.entites import BaseTaskParams, BaseTaskType
from sendr_utils import utcnow


@unique
class WorkerState(Enum):
    RUNNING = 'running'
    SHUTDOWN = 'shutdown'
    FAILED = 'failed'
    CLEANEDUP = 'cleanedup'


@unique
class TaskState(Enum):
    FAILED = 'failed'
    PENDING = 'pending'
    PROCESSING = 'processing'
    FINISHED = 'finished'
    DELETED = 'deleted'
    CLEANUP = 'cleanup'


@dataclass
class RunActionTaskParams(BaseTaskParams):
    action_kwargs: Dict[str, Any]
    max_retries: int


@dataclass
class Worker(Entity):
    worker_id: str
    worker_type: Enum
    host: str
    state: WorkerState
    heartbeat: Optional[datetime] = None
    startup: Optional[datetime] = None
    task_id: Optional[int] = None


@dataclass
class Task(Entity):
    task_type: BaseTaskType
    task_id: Optional[int] = None
    params: Optional[Dict] = None

    state: TaskState = TaskState.PENDING
    retries: int = 0
    details: dict = field(default_factory=dict)

    action_name: Optional[str] = None

    run_at: datetime = field(default_factory=utcnow)
    created: Optional[datetime] = field(default_factory=utcnow)
    updated: Optional[datetime] = field(default_factory=utcnow)
