from datetime import timedelta
from typing import ClassVar, Optional, Type

from sendr_aiopg import StorageContextBase


class StorageMixin:
    storage_context_cls: ClassVar[Type[StorageContextBase]]
    mapper_name_worker: ClassVar[str] = 'worker'
    mapper_name_task: ClassVar[str] = 'task'

    def storage_context(self,
                        *,
                        transact: bool = False,
                        transaction_timeout: Optional[timedelta] = None) -> StorageContextBase:
        return self.storage_context_cls(
            self.app.db_engine,  # type: ignore
            transact=transact,
            logger=self.app.logger,  # type: ignore
            transaction_timeout=transaction_timeout,
        )
