try:
    from utvm.common.exceptions import (
        ContextException, TicketException, TicketParsingException, TvmException, TVMNetworkError, TVMResponseError
    )
except ImportError:
    class TvmException(Exception):  # type: ignore
        pass

    class ContextException(TvmException):  # type: ignore
        pass

    class TicketException(TvmException):  # type: ignore
        pass

    class TicketParsingException(TvmException):  # type: ignore
        def __init__(self, message, status, debug_info):
            self.message = message
            self.status = status
            self.debug_info = debug_info

    class TVMNetworkError(TvmException):  # type: ignore
        pass

    class TVMResponseError(TvmException):  # type: ignore
        pass
