import copy
from typing import Any, Dict, Optional

from jose import jws

from sendr_utils import utcnow


def get_public_key_copy(jwk: Dict[str, str]) -> Dict[str, str]:
    key = copy.copy(jwk)
    del key['d']
    return key


def get_jwt_signature(
    jwk: Dict[str, str],
    payload: Any,
    ttl_seconds: Optional[int] = None,
    extra_headers: Optional[Dict[str, Any]] = None,
) -> str:
    iat = int(utcnow().timestamp())
    headers = {
        'iat': iat,
        'kid': jwk['kid'],
    }
    if ttl_seconds:
        headers['exp'] = iat + ttl_seconds
    if extra_headers:
        headers.update(extra_headers)
    return jws.sign(payload, jwk, headers=headers, algorithm='ES256')
